
%% Matlab Code for generating Gaussian white noise in the range of -10 to 10 dB in steps of 1 dB and 201 test signals for each SNR
clc;
close all;   
%% Load 10 real coarse crackles here 
load RC1
load RC2
load RC3
load RC4
load RC5
load RC6
load RC7
load RC8
load RC9
load RC10
fs              = 44100;                                                       %% Sampling frequency
Signal_length   = 32768;                                                       %% Signal length
%% Make the length equal
RC1             = [zeros(1,1000),RC1,zeros(1,Signal_length-(1000+length(RC1)))];
RC2             = [zeros(1,3000),RC2,zeros(1,Signal_length-(3000+length(RC2)))];
RC3             = [zeros(1,7000),RC3,zeros(1,Signal_length-(7000+length(RC3)))];
RC4             = [zeros(1,12000),RC4,zeros(1,Signal_length-(12000+length(RC4)))];
RC5             = [zeros(1,14000),RC5,zeros(1,Signal_length-(14000+length(RC5)))];
RC6             = [zeros(1,17000),RC6,zeros(1,Signal_length-(17000+length(RC6)))];
RC7             = [zeros(1,20000),RC7,zeros(1,Signal_length-(20000+length(RC7)))];
RC8             = [zeros(1,23000),RC8,zeros(1,Signal_length-(23000+length(RC8)))];
RC9             = [zeros(1,27500),RC9,zeros(1,Signal_length-(27500+length(RC9)))];
RC10            = [zeros(1,30000),RC10,zeros(1,Signal_length-(30000+length(RC10)))];
Ten_real_coarse_crackles        = RC1+RC2+RC3+RC4+RC5+RC6+RC7+RC8+RC9+RC10;
Ten_real_coarse_crackles        = Ten_real_coarse_crackles(1:end);                                                              
%% Preallocate variables here


%% Start SNR and Iterative loops
for SNR_loop        = -10:1:10                                                %% Start signal to noise ratio loop
for iterative_loop  = 1:201                                                   %% Start number of iterations loop 
%% Generate Gaussian white noise
Signal      = awgn(Ten_real_coarse_crackles,SNR_loop,'measured');             %% Signal with 10 real coarse crackles buried under Gaussian white noise
                                                                 

%% Use your separation technique here


end
end
